/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.table;

import filenet.vw.toolkit.runtime.VWDuration;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerStatus;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWTrackerSummaryCellRenderer
extends DefaultTableCellRenderer {
    private static DateFormat s_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        component.applyComponentOrientation(compOrientation);
        String string = null;
        ((JLabel)component).setText("");
        ((JLabel)component).setIcon(null);
        if (compOrientation.isLeftToRight()) {
            ((JLabel)component).setHorizontalAlignment(2);
        } else {
            ((JLabel)component).setHorizontalAlignment(4);
        }
        if (value != null) {
            if (value instanceof Calendar || value instanceof Date) {
                Date date = null;
                if (value instanceof Calendar) {
                    date = ((Calendar)value).getTime();
                } else if (value instanceof Date) {
                    date = (Date)value;
                }
                if (date != null) {
                    string = s_dateTimeFormatter.format(date);
                    ((JLabel)component).setText(string);
                }
            } else if (value instanceof VWTrackerStatus) {
                VWTrackerStatus status = (VWTrackerStatus)value;
                if (status.getDate() != null) {
                    string = s_dateTimeFormatter.format(status.getDate());
                    ((JLabel)component).setText(string);
                } else {
                    ((JLabel)component).setText("");
                }
                int stat = status.getStatus();
                ImageIcon icon = VWImageLoader.createStatusIcon(stat);
                switch (stat) {
                    case 1: {
                        string = VWResource.s_inProgress;
                        ((JLabel)component).setText(string);
                        break;
                    }
                    case 9: {
                        string = VWResource.s_overdue;
                        ((JLabel)component).setText(string);
                        break;
                    }
                    case 10: {
                        string = VWResource.s_reminded;
                        ((JLabel)component).setText(string);
                        break;
                    }
                    case 11: {
                        string = VWResource.s_inSubmap;
                        ((JLabel)component).setText(string);
                        break;
                    }
                    case 12: {
                        string = VWResource.s_exception;
                        ((JLabel)component).setText(string);
                        break;
                    }
                    case 13: {
                        string = VWResource.s_pastException;
                        ((JLabel)component).setText(string);
                    }
                }
                ((JLabel)component).setIcon(icon);
            } else if (value instanceof Integer) {
                Integer integer = (Integer)value;
                string = integer.toString();
                ((JLabel)component).setText(string);
                ((JLabel)component).setHorizontalAlignment(0);
            } else if (value instanceof VWDuration) {
                VWDuration duration = (VWDuration)value;
                string = duration.toString();
                ((JLabel)component).setText(string);
            } else if (value instanceof JLabel) {
                JLabel label = (JLabel)value;
                string = label.getText();
                ((JLabel)component).setText(string);
                ((JLabel)component).setIcon(label.getIcon());
                ((JLabel)component).setToolTipText(label.getToolTipText());
            } else if (value instanceof String) {
                String s = new String("");
                string = (String)value;
                StringTokenizer st = new StringTokenizer(string, "\n");
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    while (st.hasMoreTokens()) {
                        s = s + "   " + st.nextToken();
                    }
                }
                ((JLabel)component).setText(s);
            }
        }
        if (component != null && component instanceof JComponent && ((JComponent)component).getToolTipText() == null) {
            ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(string, 0));
        }
        return component;
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        String string = null;
        if (value instanceof Calendar || value instanceof Date) {
            Date date = null;
            if (value instanceof Calendar) {
                date = ((Calendar)value).getTime();
            } else if (value instanceof Date) {
                date = (Date)value;
            }
            if (date != null) {
                string = s_dateTimeFormatter.format(date);
            }
        } else if (value instanceof VWTrackerStatus) {
            VWTrackerStatus status = (VWTrackerStatus)value;
            if (status.getDate() != null) {
                string = s_dateTimeFormatter.format(status.getDate());
            }
            int stat = status.getStatus();
            switch (stat) {
                case 1: {
                    string = VWResource.s_inProgress;
                    break;
                }
                case 9: {
                    string = VWResource.s_overdue;
                    break;
                }
                case 10: {
                    string = VWResource.s_reminded;
                    break;
                }
                case 11: {
                    string = VWResource.s_inSubmap;
                    break;
                }
                case 12: {
                    string = VWResource.s_exception;
                    break;
                }
                case 13: {
                    string = VWResource.s_pastException;
                }
            }
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            string = integer.toString();
        } else if (value instanceof VWDuration) {
            VWDuration duration = (VWDuration)value;
            string = duration.toString();
        } else if (value instanceof JLabel) {
            JLabel label = (JLabel)value;
            string = label.getText();
        } else if (value instanceof String) {
            string = (String)value;
        }
        return string;
    }

    public static ImageIcon getIcon(Object value) {
        if (value == null) {
            return null;
        }
        ImageIcon icon = null;
        if (value instanceof VWTrackerStatus) {
            VWTrackerStatus status = (VWTrackerStatus)value;
            int stat = status.getStatus();
            icon = VWImageLoader.createStatusIcon(stat);
        } else if (value instanceof JLabel) {
            icon = (ImageIcon)((JLabel)value).getIcon();
        }
        return icon;
    }
}

